#### Interpreting MCMC Output ####
#### Load Necessary "coda" package ####
library(coda)

#### Read in the coda output from OpenBUGS ####
symptoms.slope.coda <- read.openbugs( "symptoms_slope_" )
symptoms.slope.prior.coda <- read.openbugs( "symptoms_slope_prior_" )
symptoms.intercept.coda <- read.openbugs( "symptoms_intercept_" )
symptoms.intercept.prior.coda <- read.openbugs( "symptoms_intercept_prior_" )
income.slope.coda <- read.openbugs( "income_slope_" )
income.slope.prior.coda <- read.openbugs( "income_slope_prior_" )
income.intercept.coda <- read.openbugs( "income_intercept_" )
income.intercept.prior.coda <- read.openbugs( "income_intercept_prior_" )

#### Run some diagnostics ####
gelman.diag(symptoms.slope.coda)
autocorr.diag(symptoms.slope.coda)
gelman.diag(symptoms.intercept.coda)
autocorr.diag(symptoms.intercept.coda)

#### Bayesian Hypothesis Tests ####
#### Load the function bayes.test() ####
## implements the method detailed by Wagenmakers et al. 

source("http://page-gould.com/scripts/r/bayes.test.r")

##The function bayes.test() takes three arguments: an mcmc.list object for the 
## prior coda, an mcmc.list object for the posterior coda, and a numeric object or 
## vector of hypothesized values for the parameter. They must be in the order of: 
## bayes.test( prior, posterior, hypotheses )

#### Using the Savage-Dickey Method ####
bayes.test(symptoms.intercept.prior.coda, symptoms.intercept.coda, 3)
bayes.test(symptoms.slope.prior.coda, symptoms.slope.coda, c(0, .14, .35, .66))
bayes.test(income.slope.prior.coda, income.slope.coda, 0)